Attribute VB_Name = "BrowseFolders"
Option Explicit

' Der UDT BrowseInfo dient zur Parameterbergabe
' fr die Funktion SHBrowseForFolder
Public Type BrowseInfo
  hwndOwner      As Long
  pIDLRoot       As Long
  pszDisplayName As Long
  lpszTitle      As Long
  ulFlags        As Long
  lpfnCallback   As Long
  lParam         As Long
  iImage         As Long
End Type

' Aufzhlung mit den vordefinierten Shell-/Systemordnern
Public Enum SHELLFOLDERS
    CSIDL_DESKTOP = &H0&       ' Desktop
    CSIDL_PROGRAMS = &H2&      ' Programme
    CSIDL_CONTROLS = &H3&      ' Systemsteuerung
    CSIDL_PRINTERS = &H4&      ' Drucker
    CSIDL_PERSONAL = &H5&      ' Eigene Dateien
    CSIDL_FAVORITES = &H6&     ' Favoriten
    CSIDL_STARTUP = &H7&       ' Autostart
    CSIDL_RECENT = &H8&        ' Dokumente
    CSIDL_SENDTO = &H9&        ' Senden An
    CSIDL_BITBUCKET = &HA&     ' Papierkorb
    CSIDL_STARTMENU = &HB&     ' Startmen
    CSIDL_DESKTOPDIRECTORY = &H10& ' Desktop ??
    CSIDL_DRIVES = &H11&        ' Laufwerke = Arbeitsplatz
    CSIDL_NETWORK = &H12&       ' Netzwerk
    CSIDL_NETHOOD = &H13&       ' Netzwerkumgebung (akt. Arbeitsgruppe?)
    CSIDL_FONTS = &H14&         ' Fonts / Schiftenfolder
    CSIDL_TEMPLATES = &H15&     ' ShellNew
    CSIDL_COMMON_STARTMENU = &H16&
    CSIDL_COMMON_PROGRAMS = &H17&
    CSIDL_COMMON_STARTUP = &H18&
    CSIDL_COMMON_DESKTOPDIRECTORY = &H19&
    CSIDL_APPDATA = &H1A&
    CSIDL_PRINTHOOD = &H1B&
End Enum

Public Const WM_USER = &H400

' Browse For Folder Callback Messages:
Public Const BFFM_INITIALIZED = 1
Public Const BFFM_SELCHANGED = 2
Public Const BFFM_SETSTATUSTEXT = (WM_USER + 100)
Public Const BFFM_ENABLEOK = (WM_USER + 101)
Public Const BFFM_SETSELECTION = (WM_USER + 102)

' BROWSEINFO ulFlags values:
' Value specifying the types of folders to be listed in the dialog box as well as other options. This member can include zero or more of the following values:
' Only returns file system directories. If the user selects folders that are not part of the file system, the OK button is grayed.
Public Const BIF_RETURNONLYFSDIRS = &H1
' Does not include network folders below the domain level in the tree view control. For starting the Find Computer
Public Const BIF_DONTGOBELOWDOMAIN = &H2
' Includes a status area in the dialog box. The callback function can set the status text by sending messages to the dialog box.
Public Const BIF_STATUSTEXT = &H4
' Only returns file system ancestors. If the user selects anything other than a file system ancestor, the OK button is grayed.
Public Const BIF_RETURNFSANCESTORS = &H8
' Only returns computers. If the user selects anything other than a computer, the OK button is grayed.
Public Const BIF_BROWSEFORCOMPUTER = &H1000
' Only returns (network) printers. If the user selects anything other than a printer, the OK button is grayed.
Public Const BIF_BROWSEFORPRINTER = &H2000

Public Const MAX_PATH = 255

' API Aufrufe deklarieren:
Public Declare Function lstrcat Lib "kernel32" Alias "lstrcatA" (ByVal lpString1 As String, ByVal lpString2 As String) As Long
Public Declare Function SHBrowseForFolder Lib "Shell32" (lpbi As BrowseInfo) As Long
Public Declare Function SHGetPathFromIDList Lib "Shell32" (ByVal pidList As Long, ByVal lpBuffer As String) As Long
Public Declare Function SHGetSpecialFolderLocation Lib "Shell32" (ByVal hwndOwner As Long, ByVal nFolder As Integer, ppidl As Long) As Long
Public Declare Function SendMessage& Lib "user32.dll" Alias "SendMessageA" (ByVal hWnd&, ByVal uMsg&, ByVal wparam&, lParam As Any)

Public Function GetAddr(lAddr&) As Long
  GetAddr = lAddr
End Function

Public Function BrowseForFolderCallback(ByVal hWnd&, ByVal uMsg&, ByVal lParam&, ByVal lpData&) As Long
  Dim sPath$, nPos%
  Select Case uMsg
    Case BFFM_INITIALIZED
      
    Case BFFM_SELCHANGED
      sPath = Space(MAX_PATH)
      SHGetPathFromIDList lParam, sPath
      sPath = Left$(sPath, InStr(sPath, Chr$(0)) - 1)
      If Len(sPath) <= 2 Then
        'OK deaktivieren
        SendMessage hWnd, BFFM_ENABLEOK, 0, ByVal 0&
        'Eigenen Text einblenden:
        'SendMessage hWnd, BFFM_SETSTATUSTEXT, 0, ByVal "Auswahl nicht mglich!"
      Else
        'OK aktivieren, wenn Auswahl gltig ist
        SendMessage hWnd, BFFM_ENABLEOK, 0, ByVal 1&
        'Eigenen Text einblenden:
        'SendMessage hWnd, BFFM_SETSTATUSTEXT, 0, ByVal "Auswahl mglich!"
      End If
  End Select
End Function

Public Function BrowseFolder(rootIDL As Long) As String
    '*********************************************
    ' rootIDL ist der Hauptknoten, von dem aus
    ' das Verz. gewhlt werden soll
    ' siehe dazu CSIDL_
    '*********************************************
    ' Mit SHGetPathFromIDList kann man
    ' Systemverz. ermitteln !
    '*********************************************
   
    Dim tBrowseInfo As BrowseInfo
    Dim pidl As Long
    Dim sPath As String
    With tBrowseInfo
       If rootIDL > 0 Then
          SHGetSpecialFolderLocation Screen.ActiveForm.hWnd, rootIDL, .pIDLRoot
       End If
        .hwndOwner = Screen.ActiveForm.hWnd
       .lpszTitle = lstrcat("Bitte den Ordner auswhlen ...", "")
       .lpfnCallback = GetAddr(AddressOf BrowseForFolderCallback)
       
       'NUR VERZEICHNISUASWAHL MGLICH, KEINE SYSTEMORDNER ANZEIGEN
       .ulFlags = BIF_RETURNONLYFSDIRS Or BIF_RETURNFSANCESTORS 'Or BIF_STATUSTEXT
       
    End With
    'Hier sollte ein Klick_Ok hin ...
    pidl = SHBrowseForFolder(tBrowseInfo)
    If pidl Then
       sPath = String$(MAX_PATH, 0)
       SHGetPathFromIDList pidl, sPath
       BrowseFolder = Left$(sPath, InStr(sPath, Chr$(0)))
    Else
       BrowseFolder = ""
    End If
End Function


