Attribute VB_Name = "FormatedDrive"

'*******************************************************************************
' How to format a disk without user intervention.
' Hook and declarations module.
'*******************************************************************************'
' Author: Eduardo Morcillo
' E-Mail: edanmo@geocities.com
' Web Page: http://www.domaindlx.com/e_morcillo
'
' Created: 10/29/1999
' Updates: 01/26/2000 * All code moved from the form to a
'                       wrapper function.
'                     * The code now supports format types,
'                       summary and system files.
'*******************************************************************************
' Laufwerk, Disktyp, Formatierung, Zusammenfassung zeigen, Systemdateien kopieren
' FormatDrive "A", fcDefault, ftQuick, False, True
'*******************************************************************************

Option Explicit

Public hHook As Long
Private bShowSummary As Boolean
Private lFormatType As Long
Private bWithSysFiles As Boolean

Private Declare Function SHFormatDrive Lib "shell32" (ByVal hwndOwner As Long, ByVal iDrive As Long, ByVal iCapacity As Long, ByVal iFormatType As Long) As Long

Const WH_CBT = 5

Private Declare Function SetWindowsHookEx Lib "User32" Alias "SetWindowsHookExA" (ByVal idHook As Long, ByVal lpfn As Long, ByVal hmod As Long, ByVal dwThreadId As Long) As Long
Private Declare Function UnhookWindowsHookEx Lib "User32" (ByVal hHook As Long) As Long
Private Declare Function CallNextHookEx Lib "User32" (ByVal hHook As Long, ByVal ncode As Long, ByVal wParam As Long, lParam As Any) As Long

Const HCBT_ACTIVATE = 5

Private Declare Function ShowWindow Lib "User32" (ByVal hwnd As Long, ByVal nCmdShow As Long) As Long
Private Declare Function GetDlgItem Lib "User32" (ByVal hDlg As Long, ByVal nIDDlgItem As Long) As Long
Private Declare Function FindWindowEx Lib "User32" Alias "FindWindowExA" (ByVal hWnd1 As Long, ByVal hWnd2 As Long, ByVal lpsz1 As String, ByVal lpsz2 As String) As Long

Private Declare Function MoveWindow Lib "User32" (ByVal hwnd As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal bRepaint As Long) As Long

Private Declare Function SendMessage Lib "User32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long

Const WM_SETTEXT = &HC
Const WM_CHAR = &H102
Const EN_CHANGE = &H300

Const BM_SETCHECK = &HF1
Const BM_CLICK = &HF5

Const BST_UNCHECKED = &H0
Const BST_CHECKED = &H1
Const BST_INDETERMINATE = &H2

Private Declare Function SetWindowPos Lib "User32" (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal x As Long, ByVal y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long

' SetWindowPos Flags
Const SWP_NOSIZE = &H1
Const SWP_NOMOVE = &H2
Const SWP_NOZORDER = &H4
Const SWP_SHOWWINDOW = &H40

' Format dialog control IDs
Const ID_START = &H1
Const ID_CANCEL = &H2
Const ID_DRIVES = &H20
Const ID_FULL = &H21
Const ID_QUICK = &H22
Const ID_JUSTSYS = &H23
Const ID_PROGRESS = &H24
Const ID_STATUS = &H25
Const ID_LABEL = &H26
Const ID_NOLABEL = &H27
Const ID_COPYSYS = &H28
Const ID_SHOWSUMMARY = &H29
Const ID_FORMATMODE = &H1202
Const ID_CAPACITY = &H1208

Enum FormatCapacity
    fcDefault = 0 ' default drive capacity
    fc360 = 3     ' 360KB, applies to 5.25" drives only
    fc720 = 5     ' 720KB, applies to 3.5" drives only
End Enum

Enum FormatType
    ftQuick = 0
    ftFull
    ftSysOnly
End Enum

Private Function CBTHook(ByVal Code As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Dim Start As Long, Child As Long, hWndFormat As Long

   Select Case Code
      Case HCBT_ACTIVATE
                            
         ' Destroy this hook
         UnhookWindowsHookEx hHook
         
         ' Get the format dlg hWnd
         hWndFormat = wParam
         
         ' Find the start button
         Start = GetDlgItem(hWndFormat, ID_START)
         
         ' Set No label checkbox
         Child = GetDlgItem(hWndFormat, ID_NOLABEL)
         SendMessage Child, BM_SETCHECK, BST_CHECKED, 0
         
         ' Set the format type
         Select Case lFormatType
            Case ftQuick
               Child = GetDlgItem(hWndFormat, ID_QUICK)
               
            Case ftSysOnly
               Child = GetDlgItem(hWndFormat, ID_JUSTSYS)
            
            Case Else
               Child = GetDlgItem(hWndFormat, ID_FULL)
         
         End Select
         
         SendMessage Child, BM_SETCHECK, BST_CHECKED, 0
         
         ' Set the Show summary
         Child = GetDlgItem(hWndFormat, ID_SHOWSUMMARY)
         If bShowSummary Then
            SendMessage Child, BM_SETCHECK, BST_CHECKED, 0
         Else
            SendMessage Child, BM_SETCHECK, BST_UNCHECKED, 0
         End If
         
         ' Set copy sys files
         Child = GetDlgItem(hWndFormat, ID_COPYSYS)
         If bWithSysFiles Then
            SendMessage Child, BM_SETCHECK, BST_CHECKED, 0
         Else
            SendMessage Child, BM_SETCHECK, BST_UNCHECKED, 0
         End If
         
         ' Get the progress bar and move it
         Child = GetDlgItem(hWndFormat, ID_PROGRESS)
         'MoveWindow Child, 5, 25, 185, 15, True
         
         ' Get the drives combo and hide it
         Child = GetDlgItem(hWndFormat, ID_DRIVES)
         'ShowWindow Child, 0
         
         ' Get the Capacity label hide it
         Child = GetDlgItem(hWndFormat, ID_CAPACITY)
         'ShowWindow Child, 0
         
         ' Get the formatting mode frame hide it
         Child = GetDlgItem(hWndFormat, ID_FORMATMODE)
         'ShowWindow Child, 0
         
         ' Get the "Formatting..." label and move it
         Child = GetDlgItem(hWndFormat, ID_STATUS)
         'MoveWindow Child, 5, 5, 185, 15, True
         
         ' Get the cancel button and move it
         Child = GetDlgItem(hWndFormat, ID_CANCEL)
         'SetWindowPos Child, 0, 64, 45, 0, 0, SWP_NOSIZE Or SWP_NOZORDER
                           
         ' Resize format dialog
         SetWindowPos hWndFormat, 0, 0, 0, 200, 95, SWP_NOMOVE Or SWP_NOZORDER Or SWP_SHOWWINDOW Or SWP_NOSIZE
         
         ' Click the start button
         SendMessage Start, BM_CLICK, 0, ByVal 0&
    
         ' Close the dialog
         SendMessage Child, BM_CLICK, 0, ByVal 0&
         
    End Select
        
End Function

Public Function FormatDrive(ByVal Drive As String, Optional ByVal Capacity As FormatCapacity, Optional ByVal FormatType As FormatType, Optional ShowSummary As Boolean, Optional WithSysFiles As Boolean)
Dim hWndParent As Long, lDrive As Long

   ' Start the CBT hook
   hHook = SetWindowsHookEx(WH_CBT, AddressOf CBTHook, App.hInstance, 0)
      
   ' Get the window handle of
   ' active window
   If Not Screen.ActiveForm Is Nothing Then
      hWndParent = Screen.ActiveForm.hwnd
   End If
   
   ' Save the parameters so they
   ' can be used in the hook
   bShowSummary = ShowSummary
   bWithSysFiles = WithSysFiles
   lFormatType = FormatType
   
   ' Get the drive
   lDrive = Asc(UCase$(Left$(Drive, 1))) - 65
   
   ' Call SHFormatDrive to format the drive
   SHFormatDrive hWndParent, lDrive, Capacity, FormatType

End Function


