Attribute VB_Name = "mdlDragList"
'*********************************************************************************************
'
' Drag ListBox sample
'
' Drag ListBox declarations and support functions
'
'*********************************************************************************************
'
' Author: Eduardo Morcillo
' E-Mail: edanmo@geocities.com
' Web Page: http://www.domaindlx.com/e_morcillo
'
' Created: 09/12/1999
'
'*********************************************************************************************
Option Explicit

Type POINTAPI
    X As Long
    Y As Long
End Type

Type DRAGLISTINFO
    uNotification As Long
    hWnd As Long
    ptCursor As POINTAPI
End Type

Public Const WM_USER = &H400
Public Const DL_BEGINDRAG = (WM_USER + 133)
Public Const DL_DRAGGING = (WM_USER + 134)
Public Const DL_DROPPED = (WM_USER + 135)
Public Const DL_CANCELDRAG = (WM_USER + 136)

Public Const DL_CURSORSET = 0
Public Const DL_STOPCURSOR = 1
Public Const DL_COPYCURSOR = 2
Public Const DL_MOVECURSOR = 3

Public Const DRAGLISTMSGSTRING = "commctrl_DragListMsg"

Public Declare Function MakeDragList Lib "comctl32" (ByVal hLB As Long) As Boolean
Public Declare Sub DrawInsert Lib "comctl32" (ByVal handParent As Long, ByVal hLB As Long, ByVal nItem As Long)
Public Declare Function LBItemFromPt Lib "comctl32" (ByVal hLB As Long, ByVal X As Long, ByVal Y As Long, ByVal bAutoScroll As Boolean) As Long

'*********************************************************************************************
' Moves up one position the selected item of the given
' ListBox.
'*********************************************************************************************
Public Sub LBMoveUp(LB As ListBox)
Dim Data As Long, Caption As String, Idx As Integer

    With LB
    
        Idx = .ListIndex
    
        ' The first item cannot
        ' be moved
        If Idx > 0 Then
            
            Data = .ItemData(Idx - 1)
            Caption = .List(Idx - 1)
            
            .ItemData(Idx - 1) = .ItemData(Idx)
            .List(Idx - 1) = .List(Idx)
            
            .List(Idx) = Caption
            .ItemData(Idx) = Data
            
            .ListIndex = Idx - 1
        Else
            Beep
        End If
            
    End With
    
End Sub


'*********************************************************************************************
' Moves the selected item of the given
' ListBox to the given index.
'*********************************************************************************************
Public Sub LBMoveTo(LB As ListBox, ToIdx As Integer)
Dim Data As Long, Caption As String, Idx As Integer

    With LB
    
        Idx = .ListIndex
    
        If Idx >= 0 And ToIdx >= 0 Then
            
            Data = .ItemData(Idx)
            Caption = .List(Idx)
            
            .AddItem Caption, ToIdx
            .ItemData(.NewIndex) = Data
            
            .ListIndex = ToIdx
            
            If ToIdx < Idx Then
                .RemoveItem Idx + 1
            Else
                .RemoveItem Idx
            End If
        End If
            
    End With
    
End Sub



'*********************************************************************************************
' Moves down one position the selected item of the given
' ListBox.
'*********************************************************************************************
Public Sub LBMoveDown(LB As ListBox)
Dim Data As Long, Caption As String, Idx As Integer

    With LB
        
        Idx = .ListIndex
    
        ' The last item cannot
        ' be moved down
        If Idx < .ListCount - 1 Then
            
            Data = .ItemData(Idx + 1)
            Caption = .List(Idx + 1)
            
            .ItemData(Idx + 1) = .ItemData(Idx)
            .List(Idx + 1) = .List(Idx)
            
            .List(Idx) = Caption
            .ItemData(Idx) = Data
            
            .ListIndex = Idx + 1
            
        Else
            Beep
        End If
    
    End With
    
End Sub



