Attribute VB_Name = "mdlSubclass"

'*********************************************************************************************
' Drag ListBox
' Subclassing module
'
' Author: Eduardo Morcillo
' E-Mail: edanmo@geocities.com
' Web Page: http://www.domaindlx.com/e_morcillo
'
' Created: 09/12/1999
'
'*********************************************************************************************
Option Explicit

Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hWnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Declare Function CallWindowProc Lib "user32" Alias "CallWindowProcA" (ByVal lpPrevWndFunc As Long, ByVal hWnd As Long, ByVal Msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Declare Function RegisterWindowMessage Lib "user32" Alias "RegisterWindowMessageA" (ByVal lpString As String) As Long
Declare Sub MoveMemory Lib "kernel32" Alias "RtlMoveMemory" (Dest As Any, Src As Any, ByVal L As Long)

Public Const GWL_WNDPROC = (-4)
Public DL_Message As Long
Public PrevProc As Long

Public Function WinProc(ByVal hWnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    Static DragIdx As Long
    Dim DLI As DRAGLISTINFO

    Select Case uMsg
        Case DL_Message
            MoveMemory DLI, ByVal lParam, Len(DLI)
            Select Case DLI.uNotification
                Case DL_BEGINDRAG
                    ' The drag operation starts.
                    ' Return False to cancel
                    ' Get the selected item
                    DragIdx = LBItemFromPt(DLI.hWnd, DLI.ptCursor.X, DLI.ptCursor.Y, False)
                    ' Continue with the drag
                    WinProc = True
                Case DL_CANCELDRAG
                    ' The drag was canceled
                    Form1.List1.MousePointer = vbDefault
                    Form1.Cls
                Case DL_DRAGGING
                    ' The item is being dragged
                    ' Draw the insert icon
                    DrawInsert Form1.hWnd, Form1.List1.hWnd, LBItemFromPt(DLI.hWnd, DLI.ptCursor.X, DLI.ptCursor.Y, True)
                    ' Return one of:
                    '
                    ' DL_STOPCURSOR: Changes the cursor to stop
                    ' DL_COPYCURSOR: Changes the cursor to copy
                    ' DL_MOVECURSOR: Changes the cursor to move
                    ' Other: the cursor is not changed
                    '
                    Form1.List1.MousePointer = vbCustom
                    WinProc = 0
                Case DL_DROPPED
                    If LBItemFromPt(DLI.hWnd, DLI.ptCursor.X, DLI.ptCursor.Y, True) <> DragIdx Then
                        LBMoveTo Form1.List1, LBItemFromPt(DLI.hWnd, DLI.ptCursor.X, DLI.ptCursor.Y, True)
                    End If
                   
                    Form1.List1.MousePointer = vbDefault
                    Form1.Cls
            End Select
            Exit Function
    End Select
    WinProc = CallWindowProc(PrevProc, hWnd, uMsg, wParam, lParam)

End Function

