Attribute VB_Name = "Win32Version"
Private Declare Function GetVersionEx Lib "kernel32" Alias "GetVersionExA" _
(lpVersionInformation As OSVERSIONINFO) As Long

Private Type OSVERSIONINFO
    dwOSVersionInfoSize As Long
    dwMajorVersion As Long
    dwMinorVersion As Long
    dwBuildNumber As Long
    dwPlatformId As Long
    szCSDVersion As String * 128  'Maintenance string for PSS usage
End Type

Private Const VER_PLATFORM_WIN32_NT = 2
Private Const VER_PLATFORM_WIN32_WINDOWS = 1
Private Const VER_PLATFORM_WIN32s = 0

'Um die angeforderten Informationen nun auszuwerten braucht es noch einiger Informationen.
'So erhlt man mit der PlatformID nicht etwa direkt das Betriebssystem(auer NT) sondern
'einen Hinwei auf dieses. Bei Windows 95/98 mu danach noch die Versionsnummer untersucht
'werden. So ist Windows 98 immer mit einer x.10 gesegnet.

'Im Array .szCSDVersion aus der OSVERSIONINFO-Struktur stehen dann solche Sachen wie
'die Version des ServicePacks. Das Array ist vbNullString-getrennt und wird hier mit der Funktion
'Split() getrennt, die aber erst seit Version 6 von VB verfgbar ist(ist aber kein Grund fr mich
'darauf zu verzichten...). Wenn man die Funktion auch unter VB5 haben will, dann sollte man
'sich das Modul "VB6 Modul" unter Tools mal anschauen.

'Betriebssystem mit Informationen
Public Function WinOSVersion() As String
    Dim OSinfo As OSVERSIONINFO, CSDArray() As String, CSD As String, tmp
    OSinfo.dwOSVersionInfoSize = Len(OSinfo)
    GetVersionEx OSinfo
    
    With OSinfo
    Select Case .dwPlatformId
        Case VER_PLATFORM_WIN32s
        OS = "Windows 16bit mit 32bit-Erweiterung"
        Case VER_PLATFORM_WIN32_WINDOWS
        Select Case .dwMinorVersion
            Case 0
                OS = "95"
            Case 10
                OS = "98"
            Case 90
                OS = "Me"
            Case Else
                OS = "Unknown"
            End Select
            
            Case VER_PLATFORM_WIN32_NT
                If .dwMajorVersion = "4" Then OS = "Nt"
                If .dwMajorVersion = "5" Then OS = "XP"
            Case Else
                OS = "Unknown"
        End Select
        
        'OS = OS & " (Version " & .dwMajorVersion & "." & .dwMinorVersion & ")"
    End With
    
    WinOSVersion = OS
End Function

