Attribute VB_Name = "DialogCtrl"

'********************************************************************************

'MICROSOFT COMMON DIALOG CONTROL - DECLARES AND FUNCTION
'THIS FUNCTION DONT USE THE COMDLG32.OCX FILE, NAMELY THE COMDLG32.DLL

'********************************************************************************

'Private Sub Command1_Click()
'    Dim hImgSmall As Long   'the handle to the system image list
'    Dim fName As String     'the file name to get icon from
'    Dim fnFilter As String  'the file name filter
'    Dim r As Long
'
'   'p$ = CurDir$ 'Vorgabe-Pfad
'   p$ = WinDir & "\Desktop"
'   F$ = "" 'Vorgabe-Datei
'   a$ = Dialog_Open$(Me, "Datei ffnen", p$, F$, _
'   "Programme|*.exe; *.com; *.bat|Visual Basic Projekte|*.vbp|Textdokumente|*.doc; *.wri; *.txt|Cursor und Symbole|*.cur;

'*.ico; *.ani|Bilddateien|*.bmp; *.jpg; *.gif|Alle Dateitypen|*.*", "exe")
'   If Right$(p$, 1) <> "\" Then p$ = p$ + "\"
'   If Len(a$) Then Label1.Caption = p$ + a$
'    If a$ = "" Then Exit Sub
'    fName$ = Label1.Caption
'    hImgSmall& = SHGetFileInfo(fName$, 0&, shinfo, Len(shinfo), BASIC_SHGFI_FLAGS Or SHGFI_SMALLICON)
'    Label2.Caption = Left$(shinfo.szTypeName, InStr(shinfo.szTypeName, Chr$(0)) - 1)
'    ShellExec Label1.Caption, vbNormalFocus
'End Sub
'
'Private Sub Command2_Click()
'   p$ = CurDir$ 'Vorgabe-Pfad
'   F$ = "" 'Vorgabe-Datei
'   a$ = Dialog_Save$(Me, "Datei speichern", p$, F$, "Text-Dateien|*.txt|Alle Dateien|*.*", "txt")
'   If Right$(p$, 1) <> "\" Then p$ = p$ + "\"
'   If Len(a$) Then MsgBox p$ + a$
'End Sub

'**********************************************************************************

Public shinfo As SHFILEINFO
Public Const MAX_PATH = 260
Public Const SHGFI_DISPLAYNAME = &H200

Public Const SHGFI_EXETYPE = &H2000
Public Const SHGFI_SYSICONINDEX = &H4000 'system icon index
Public Const SHGFI_LARGEICON = &H0 'large icon
Public Const SHGFI_SMALLICON = &H1 'small icon
Public Const SHGFI_SHELLICONSIZE = &H4
Public Const SHGFI_TYPENAME = &H400

Public Const BASIC_SHGFI_FLAGS = SHGFI_TYPENAME _
Or SHGFI_DISPLAYNAME Or SHGFI_EXETYPE

Private Const OFN_HIDEREADONLY = &H4
Private Const OFN_PATHMUSTEXIST = &H800
Private Const OFN_FILEMUSTEXIST = &H1000
Private Const OFN_OVERWRITEPROMPT = &H2

Public Type SHFILEINFO
   hIcon As Long
   iIcon As Long
   dwAttributes As Long
   szDisplayName As String * MAX_PATH
   szTypeName As String * 80
End Type

Private Type OPENFILENAME
   lStructSize As Long
   hwndOwner As Long
   hInstance As Long
   lpstrFilter As String
   lpstrCustomFilter As String
   nMaxCustFilter As Long
   nFilterIndex As Long
   lpstrFile As String
   nMaxFile As Long
   lpstrFileTitle As String
   nMaxFileTitle As Long
   lpstrInitialDir As String
   lpstrTitle As String
   flags As Long
   nFileOffset As Integer
   nFileExtension As Integer
   lpstrDefExt As String
   lCustData As Long
   lpfnHook As Long
   lpTemplateName As String
End Type

'Deklaration:
Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hwnd As Long, ByVal lpOperation As String, _
ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, _
ByVal nShowCmd As Long) As Long

Declare Function GetOpenFileName Lib "comdlg32.dll" Alias _
"GetOpenFileNameA" (pOpenfilename As OPENFILENAME) As Long

Declare Function GetSaveFileName Lib "comdlg32.dll" Alias _
"GetSaveFileNameA" (pOpenfilename As OPENFILENAME) As Long

Public Declare Function SHGetFileInfo Lib "shell32.dll" Alias "SHGetFileInfoA" _
(ByVal pszPath As String, ByVal dwFileAttributes As Long, psfi As SHFILEINFO, _
ByVal cbSizeFileInfo As Long, ByVal uFlags As Long) As Long

Private Declare Function GetWindowsDirectory Lib "kernel32" _
Alias "GetWindowsDirectoryA" (ByVal lpBuffer As String, _
ByVal nSize As Long) As Long

Private Declare Function GetSystemDirectory Lib "kernel32" _
Alias "GetSystemDirectoryA" (ByVal lpBuffer As String, _
ByVal nSize As Long) As Long

Private Declare Function GetTempPath Lib "kernel32" _
Alias "GetTempPathA" (ByVal nBufferLength As Long, _
ByVal lpBuffer As String) As Long

Public Function WinDir() As String
   Dim sDirBuf As String * 255
   StrLen = GetWindowsDirectory(sDirBuf, 255)
   WinDir = Left$(sDirBuf, StrLen)
End Function

Public Function SysDir() As String
   Dim sDirBuf As String * 255
   StrLen = GetSystemDirectory(sDirBuf, 255)
   SysDir = Left$(sDirBuf, StrLen)
End Function

Public Function TempDir() As String
   Dim sDirBuf As String * 255
   StrLen = GetTempPath(255, sDirBuf)
   TempDir = Left$(sDirBuf, StrLen)
End Function

'Routine:
Function ShellExec(ByVal DokPfad As String, _
    Optional ByVal WindowStyle As VbAppWinStyle = vbMinimizedFocus)
  If ShellExecuteA(0&, "open", DokPfad, _
      vbNullString, vbNullString, WindowStyle) > 32 _
  Then ShellExec = True
End Function

Function DialogOpenSave$(F As Form, ByVal ftitle$, _
   fpfad$, ByVal ffile$, ByVal ffilter$, ByVal fext$, SaveFile%)

   Dim O As OPENFILENAME
   Dim wSize As Long
   Dim Memhandle As Long

   szFile$ = ffile$ + String$(128 - Len(ffile$), 0)
   szFilter$ = ffilter$ + "||"
   Do While InStr(szFilter$, "|")
      szFilter$ = Left$(szFilter$, InStr(szFilter$, "|") - 1) + Chr$(0) + _
         Mid$(szFilter$, InStr(szFilter$, "|") + 1)
   Loop

   O.lStructSize = Len(O)
   O.hwndOwner = F.hwnd
   O.nFilterIndex = 1
   O.nMaxFile = Len(szFile$)

   Select Case SaveFile%
      Case 0:
         O.flags = OFN_HIDEREADONLY Or OFN_PATHMUSTEXIST Or _
             OFN_FILEMUSTEXIST
      Case 1:
         O.flags = OFN_HIDEREADONLY Or OFN_PATHMUSTEXIST Or _
            OFN_OVERWRITEPROMPT
      Case 2:
         O.flags = OFN_HIDEREADONLY Or OFN_PATHMUSTEXIST
  End Select

   O.lpstrFile = szFile$
   O.lpstrFilter = szFilter$
   O.lpstrTitle = ftitle$
   O.lpstrDefExt = fext$
   O.lpstrInitialDir = fpfad$

   If SaveFile% = 0 Then
      result = GetOpenFileName(O)
   Else
      result = GetSaveFileName(O)
   End If

   file$ = Left$(O.lpstrFile, InStr(O.lpstrFile, Chr$(0)) - 1)

   If result = 0 Then DialogOpenSave$ = "": Exit Function

   fpfad$ = Left$(file$, O.nFileOffset)
   DialogOpenSave$ = Right$(file$, Len(file$) - O.nFileOffset)
End Function

Function Dialog_Open$(F As Form, ByVal ftitle$, fpfad$, _
    ByVal ffile$, ByVal ffilter$, ByVal fext$)
    Dialog_Open$ = DialogOpenSave$(F, ftitle$, fpfad$, ffile$, ffilter$, fext$, 0)
End Function

Function Dialog_Save$(F As Form, ByVal ftitle$, fpfad$, _
    ByVal ffile$, ByVal ffilter$, ByVal fext$)
    Dialog_Save$ = DialogOpenSave$(F, ftitle$, fpfad$, ffile$, ffilter$, fext$, 1)
End Function


