VERSION 5.00
Begin VB.Form Root 
   BorderStyle     =   3  'Fester Dialog
   Caption         =   "Properties/Eigenschaften"
   ClientHeight    =   5685
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   7995
   BeginProperty Font 
      Name            =   "Verdana"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "Root.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5685
   ScaleWidth      =   7995
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.ListBox FilesList 
      Height          =   4935
      Left            =   3645
      Sorted          =   -1  'True
      TabIndex        =   2
      Top             =   135
      Width           =   4200
   End
   Begin VB.ListBox FolderList 
      Height          =   4545
      Left            =   135
      Sorted          =   -1  'True
      TabIndex        =   1
      Top             =   540
      Width           =   3435
   End
   Begin VB.DriveListBox Drive1 
      Height          =   315
      Left            =   135
      TabIndex        =   0
      Top             =   135
      Width           =   3435
   End
   Begin VB.CommandButton cmdFileProperties 
      Caption         =   "&Datei"
      Height          =   375
      Left            =   6750
      TabIndex        =   5
      Top             =   5220
      Width           =   1095
   End
   Begin VB.CommandButton cmdFolderProperties 
      Caption         =   "&Ordner"
      Height          =   375
      Left            =   5580
      TabIndex        =   4
      Top             =   5220
      Width           =   1095
   End
   Begin VB.CommandButton cmdDriveProperties 
      Caption         =   "&Laufwerk"
      Height          =   375
      Left            =   4410
      TabIndex        =   3
      Top             =   5220
      Width           =   1095
   End
   Begin VB.Label lbCurrPath 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Label1"
      Height          =   195
      Left            =   180
      TabIndex        =   6
      Top             =   5265
      Width           =   555
   End
End
Attribute VB_Name = "Root"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Sub Form_Load()
    Me.Move (Screen.Width - Me.Width) \ 2, (Screen.Height - Me.Height) \ 2
    Me.Visible = True
    
    LoadFolderInfo
End Sub

Private Sub cmdFileProperties_Click()
    FilesList_DblClick
End Sub

Private Sub cmdFolderProperties_Click()
    'berprfen ob sich der Inhalt des Ordners gendert hat
    If Right$(CurDir, 1) <> "\" Then h = "\" Else h = ""
    If Not DirExists(CurDir & h & FolderList.List(FolderList.ListIndex)) Then
        LoadFolderInfo
        
        If FolderList.ListCount = 0 Then _
        FolderList_DblClick
        Exit Sub
    End If
    
    'Eigenschaften des Ordners anzeigen
    ShowProperties (FolderList.List(FolderList.ListIndex))
End Sub

Private Sub cmdDriveProperties_Click()
    'Eigenschaften des Laufwerks anzeigen
    ShowProperties (Left$(Drive1.List(Drive1.ListIndex), 2))
End Sub

Private Sub Drive1_Change()
    'Lesefehler (Laufwerk nicht bereit) bergehen
    On Local Error GoTo Drive1_Error
    
    FolderList.Clear
    FilesList.Clear
    
Drive1_Read:
    'Change to the selected drive
    cmdDriveProperties.Enabled = True
    ChDrive Drive1.Drive
    
    'Get the info
    LoadFolderInfo
Exit Sub

Drive1_Error:
    'The selected drive is not ready.
    cmdDriveProperties.Enabled = False
    x = MsgBox("Von diesem Laufwerk konnte nicht gelesen werden. ", 21, " Datentrger einlegen")
    If x = 2 Then Exit Sub
    If x = 4 Then If Not DirExists(Drive1.Drive) Then GoTo Drive1_Error
    GoTo Drive1_Read
End Sub

Private Sub FilesList_Click()
  'only enable the properies button if both an item is
  'selected, and that item is not the 'no files' message
   cmdFileProperties.Enabled = (FilesList.ListIndex > -1) And _
        (FilesList.List(FilesList.ListIndex)) <> ""
End Sub

Private Sub FilesList_DblClick()
    'berprfen ob sich der Inhalt des Ordners gendert hat
    If Right$(CurDir, 1) <> "\" Then h = "\" Else h = ""
    If Not FileExists(CurDir & h & (FilesList.List(FilesList.ListIndex))) Then
        LoadFolderInfo
        
        If FolderList.ListCount = 0 Then _
        FolderList_DblClick
        Exit Sub
    End If
    
    'Eigenschaften der Datei anzeigen
    ShowProperties (FilesList.List(FilesList.ListIndex))
End Sub

Private Sub FolderList_Click()
    cmdFolderProperties.Enabled = (FolderList.ListIndex > -1)
End Sub

Private Sub FolderList_DblClick()
    Dim newPath As String
    
    'berprfen ob sich die Datenstruktur gendert hat
    If Right$(CurDir, 1) <> "\" Then h = "\" Else h = ""
    If Not DirExists(CurDir & h & FolderList.List(FolderList.ListIndex)) Then
        x = MsgBox("Der Name des Ordners oder eines der bergeordneten Verzeichnisse wurde gendert oder gelscht. Die Liste der Ordner und Dateien wird deshalb aktualisiert.", 48, " Dateistruktur gendert")
        ChDir Left$(CurDir, 3)
        LoadFolderInfo
        Exit Sub
    End If
    
    'Neuen Pfad einlesen
    newPath = Trim$(FolderList.List(FolderList.ListIndex))
    
    'Den Datenpfad verndern
    If newPath = "." Then
        ChDir Left$(Drive1.Drive, 2) & "\"
    Else
        If Right$(CurDir, 1) <> "\" Then ChDir CurDir + "\" + newPath Else _
        ChDir CurDir + newPath
   End If
   
    'Dateien aus dem neuen Dateipfad auslesen
    LoadFolderInfo
End Sub

Private Function TrimNull(item As String)
    'Lschen die "chr$(0)" Zeichen aus einem String.
    Dim pos As Integer

    pos = InStr(item, Chr$(0))
    If pos Then TrimNull = Left$(item, pos - 1) Else _
    TrimNull = item
End Function

Private Sub ShowProperties(filename As String)
   Dim SEI As SHELLEXECUTEINFO
   Dim r As Long
    
   With SEI
      .cbSize = Len(SEI)
      .fMask = SEE_MASK_NOCLOSEPROCESS Or SEE_MASK_INVOKEIDLIST Or SEE_MASK_FLAG_NO_UI
      .hwnd = Me.hwnd
      .lpVerb = "properties"
      .lpFile = filename
      .lpParameters = vbNullChar
      .lpDirectory = vbNullChar
      .nShow = 0
      .hInstApp = 0
      .lpIDList = 0
   End With
    
   r = ShellExecuteEX(SEI)
End Sub

Private Sub LoadFolderInfo()
  'Display the contents of a drive/folder.

   Dim hFile As Long
   Dim fname As String
   Dim WFD As WIN32_FIND_DATA
    
   'lbCurrPath.Caption = " Reading files and directories...."
   FilesList.Clear
   FolderList.Clear
   cmdFileProperties.Enabled = False
   cmdFolderProperties.Enabled = False
   
  'Get the first file in the directory (it will usually return ".")
   hFile = FindFirstFile("*.*" & Chr$(0), WFD)
   
  'If nothing returned, bail out.
   If hFile < 0 Then Exit Sub

   Do
     'list the directories in the FolderList.
      If (WFD.dwFileAttributes And vbDirectory) Then
           
        'strip the trailing chr$(0) and add to the folder list.
         FolderList.AddItem TrimNull(WFD.cFileName)
      Else
         'strip the trailing chr$(0) and add to the file list.
          FilesList.AddItem TrimNull(WFD.cFileName)
      End If

   Loop While FindNextFile(hFile, WFD)
    
  'Close the search handle
   Call FindClose(hFile)
   
  'update both the current path label and the filelist
   If FilesList.ListCount = 0 Then FilesList.AddItem ""
   lbCurrPath.Caption = CurDir
   h = Len(lbCurrPath)
   
   'Krzt den String, wenn er zu lang ist
   If Len(lbCurrPath) >= 39 Then lbCurrPath = Left$(lbCurrPath, 38) & " ..."
   
   'Den Laufwerksbuchstaben in groem Buchstaben
   h1 = UCase$(Left$(lbCurrPath, 1))
   h2 = Mid$(lbCurrPath, 2)
   lbCurrPath = h1 & h2
End Sub

Private Sub lbCurrPath_Click()
   Dim h1, h2, hDir
   
   'Den Laufwerksbuchstaben in groem Buchstaben
   h1 = UCase$(Left$(CurDir, 1))
   h2 = Mid$(CurDir, 2)
   hDir = h1 & h2
   
   'Den Pfad als Box ausgeben
    x = MsgBox("Sie befinden sich derzeit in dem Path:  " + Chr$(10) + hDir & "  ", 64, " Aktuellen Ordner anzeigen")
End Sub
