Attribute VB_Name = "WinSystemInfo"
' Class       : COSInfo
' Description : This class implements routines for obtaining operating system
'               information.
' Source      : Total VB SourceBook 6

Private Declare Function GetUserDefaultLCID _
  Lib "kernel32" () _
  As Long

Private Declare Function GetLocaleInfo _
  Lib "kernel32" _
  Alias "GetLocaleInfoA" _
  (ByVal Locale As Long, _
  ByVal LCType As Long, _
  ByVal lpLCData As String, _
  ByVal cchData As Long) As Long

Private Declare Function CoCreateGuid _
  Lib "ole32.dll" _
  (pGUID As GUID) _
  As Long

Private Declare Function SetComputerName _
  Lib "kernel32" _
  Alias "SetComputerNameA" _
  (ByVal lpComputerName As String) _
  As Long
  
Private Declare Function GetComputerName _
  Lib "kernel32" _
  Alias "GetComputerNameA" _
  (ByVal lpBuffer As String, _
    nSize As Long) _
  As Long
    
Private Declare Function GetWindowsDirectory _
  Lib "kernel32" _
  Alias "GetWindowsDirectoryA" _
  (ByVal lpBuffer As String, _
    ByVal nSize As Long) _
  As Long
    
Private Declare Function GetSystemDirectory _
  Lib "kernel32" _
  Alias "GetSystemDirectoryA" _
  (ByVal lpBuffer As String, _
    ByVal nSize As Long) _
  As Long
  
Private Declare Function GetTempPath _
  Lib "kernel32" _
  Alias "GetTempPathA" _
  (ByVal nBufferLength As Long, _
    ByVal lpBuffer As String) _
  As Long
  
Private Declare Function GetTempFileName _
  Lib "kernel32" _
  Alias "GetTempFileNameA" _
  (ByVal lpszPath As String, _
    ByVal lpPrefixString As String, _
    ByVal wUnique As Long, _
    ByVal lpTempFileName As String) _
  As Long
    
Private Declare Function GetUserName _
  Lib "advapi32.dll" _
  Alias "GetUserNameA" _
  (ByVal lpBuffer As String, _
    nSize As Long) _
  As Long
    
Private Declare Function GetVersionEx _
  Lib "kernel32" _
  Alias "GetVersionExA" _
  (lpVersionInformation As OSVERSIONINFO) _
  As Long

Private Declare Function GetDeviceCaps _
  Lib "gdi32" _
  (ByVal hdc As Long, _
  ByVal nIndex As Long) _
  As Long

Private Declare Function GetDC _
  Lib "user32" _
  (ByVal hwnd As Long) _
  As Long
  
Private Declare Function ReleaseDC _
  Lib "user32" _
  (ByVal hwnd As Long, _
  ByVal hdc As Long) _
  As Long
  
Private Declare Function SystemParametersInfo _
  Lib "user32" _
  Alias "SystemParametersInfoA" _
  (ByVal uAction As Long, _
    ByVal uParam As Long, _
    lpvParam As Long, _
    ByVal fuWinIni As Long) _
  As Long
  
Private Declare Function GetCurrentHwProfile _
  Lib "advapi32" _
  Alias "GetCurrentHwProfileA" _
  (HwProfileInfo As HW_PROFILE_INFO) _
  As Long

Private Declare Function RegOpenKeyEx _
  Lib "advapi32.dll" _
  Alias "RegOpenKeyExA" _
  (ByVal lngHKey As Long, _
    ByVal lpSubKey As String, _
    ByVal ulOptions As Long, _
    ByVal samDesired As Long, _
    phkResult As Long) _
  As Long

Private Declare Function RegQueryValueExString _
  Lib "advapi32.dll" _
  Alias "RegQueryValueExA" _
  (ByVal lngHKey As Long, _
    ByVal lpValueName As String, _
    ByVal lpReserved As Long, _
    lpType As Long, _
    ByVal lpData As String, _
    lpcbData As Long) _
  As Long

Private Declare Function RegQueryValueExLong _
  Lib "advapi32.dll" _
  Alias "RegQueryValueExA" _
  (ByVal lngHKey As Long, _
    ByVal lpValueName As String, _
    ByVal lpReserved As Long, _
    lpType As Long, _
    lpData As Long, _
    lpcbData As Long) _
  As Long

Private Declare Function RegQueryValueExBinary _
  Lib "advapi32.dll" _
  Alias "RegQueryValueExA" _
  (ByVal lngHKey As Long, _
    ByVal lpValueName As String, _
    ByVal lpReserved As Long, _
    lpType As Long, _
    ByVal lpData As Long, _
    lpcbData As Long) _
  As Long
  
Private Declare Function RegQueryValueExNULL _
  Lib "advapi32.dll" _
  Alias "RegQueryValueExA" _
  (ByVal lngHKey As Long, _
    ByVal lpValueName As String, _
    ByVal lpReserved As Long, _
    lpType As Long, _
    ByVal lpData As Long, _
    lpcbData As Long) _
  As Long
  
Private Declare Function RegCloseKey _
  Lib "advapi32.dll" _
  (ByVal lngHKey As Long) _
  As Long

Private Const HW_PROFILE_GUIDLEN = 39
Private Const MAX_PROFILE_LEN = 80
Private Const MAX_PATH = 260

Private Const BITSPIXEL = 12
Private Const PLANES = 14
Private Const LOGPIXELSX& = 88

Private Const VER_PLATFORM_WIN32_NT = 2
Private Const VER_PLATFORM_WIN32_WINDOWS = 1
Private Const VER_PLATFORM_WIN32s = 0

Private Const SPI_GETBEEP = 1
Private Const SPI_SETBEEP = 2
Private Const SPI_GETWORKAREA = 48
Private Const SPI_GETSCREENSAVEACTIVE = 16
Private Const SPI_GETSCREENSAVETIMEOUT = 14
Private Const SPI_SETSCREENSAVEACTIVE = 17
Private Const SPI_SETSCREENSAVETIMEOUT = 15
Private Const SPIF_SENDWININICHANGE = &H2

Private Const DOCKINFO_UNDOCKED = 1
Private Const DOCKINFO_DOCKED = 2
Private Const DOCKINFO_USER_SUPPLIED = 4
Private Const DOCKINFO_USER_UNDOCKED = 5
Private Const DOCKINFO_USER_DOCKED = 6
Private Const LOCALE_SENGLANGUAGE = &H1001      '  English name of language

'Registry

Private Const HKEY_CLASSES_ROOT = &H80000000
Private Const HKEY_CURRENT_USER = &H80000001
Private Const HKEY_LOCAL_MACHINE = &H80000002
Private Const HKEY_USERS = &H80000003

Private Const mcregErrorNone = 0
Private Const mcregErrorBadDB = 1
Private Const mcregErrorBadKey = 2
Private Const mcregErrorCantOpen = 3
Private Const mcregErrorCantRead = 4
Private Const mcregErrorCantWrite = 5
Private Const mcregErrorOutOfMemory = 6
Private Const mcregErrorInvalidParameter = 7
Private Const mcregErrorAccessDenied = 8
Private Const mcregErrorInvalidParameterS = 87
Private Const mcregErrorNoMoreItems = 259

Private Const mcregKeyAllAccess = &H3F
Private Const mcregKeyQueryValue = &H1

Private Const mcregOptionNonVolatile = 0
Private Const mcregSZ As Long = 1
Private Const mcregBinary As Long = 3
Private Const mcregDWord As Long = 4

Private Type HW_PROFILE_INFO
  dwDockInfo As Long
  szHwProfileGuid As String * HW_PROFILE_GUIDLEN
  szHwProfileName As String * MAX_PROFILE_LEN
End Type

Private Type OSVERSIONINFO
  dwOSVersionInfoSize As Long
  dwMajorVersion As Long
  dwMinorVersion As Long
  dwBuildNumber As Long
  dwPlatformId As Long
  szCSDVersion As String * 128      '  Maintenance string for PSS usage
End Type

Private Type RECT
  Left As Long
  Top As Long
  Right As Long
  Bottom As Long
End Type

Private Type GUID
  Data1 As Long
  Data2 As Integer
  Data3 As Integer
  Data4(7) As Byte
End Type

Public Enum EnumWindowsType
  OSIWindows32s = 0
  OSIWindows95 = 1
  OSIWindowsNT = 2
End Enum

Property Get Beep() As Boolean
  ' Returns : True if the warning beeper is on, False if it is off
  ' Source: Total VB SourceBook 6
  Dim lngReturnValue As Long
  
  On Error GoTo PROC_ERR
  
  SystemParametersInfo SPI_GETBEEP, 0, lngReturnValue, 0
  Beep = lngReturnValue * -1

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "Beep"
  Resume PROC_EXIT

End Property

Property Let Beep(ByVal fValue As Boolean)
  ' fValue : Sets the warning beeper on or off
  ' Source: Total VB SourceBook 6

  On Error GoTo PROC_ERR
    
  SystemParametersInfo SPI_SETBEEP, fValue * 1, 0, SPIF_SENDWININICHANGE

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "Beep"
  Resume PROC_EXIT

End Property

Property Get ComputerName() As String
  ' Returns : The computer name
  ' Source: Total VB SourceBook 6
  Const cintStringLength As Integer = 100
  Dim strComputerName As String * cintStringLength
  
  On Error GoTo PROC_ERR
  
  GetComputerName strComputerName, cintStringLength
  ComputerName = TrimNulls(strComputerName)

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "ComputerName"
  Resume PROC_EXIT

End Property

Property Let ComputerName(ByVal strValue As String)
  ' strValue : Sets the computer name
  ' Source: Total VB SourceBook 6
  '
  On Error GoTo PROC_ERR

  SetComputerName strValue

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "ComputerName"
  Resume PROC_EXIT

End Property

Property Get CurrentHardwareProfile() As String
  ' Returns : The name of the current hardware profile
  ' Source: Total VB SourceBook 6
  Dim hw As HW_PROFILE_INFO
  
  On Error GoTo PROC_ERR
  
  GetCurrentHwProfile hw
  CurrentHardwareProfile = TrimNulls(hw.szHwProfileName)

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "CurrentHardwareProfile"
  Resume PROC_EXIT

End Property

Property Get DefaultCompanyName() As String
  ' Returns : The default company name used by Microsoft setup programs
  ' Source: Total VB SourceBook 6
  Const cstrKey As String = "Software\Microsoft\MS Setup (ACME)\User Info"
  Const cstrValue As String = "DefCompany"
    
  On Error GoTo PROC_ERR
  
  DefaultCompanyName = RegistryGetKeyValue(HKEY_CURRENT_USER, cstrKey, _
    cstrValue)

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "DefaultCompanyName"
  Resume PROC_EXIT

End Property

Property Get DefaultUserName() As String
  ' Returns : The default user name used by Microsoft setup programs
  ' Source: Total VB SourceBook 6
  Const cstrKey As String = "Software\Microsoft\MS Setup (ACME)\User Info"
  Const cstrValue As String = "DefName"
  
  On Error GoTo PROC_ERR
    
  DefaultUserName = RegistryGetKeyValue(HKEY_CURRENT_USER, cstrKey, cstrValue)
  
PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "DefaultUserName"
  Resume PROC_EXIT

End Property

Property Get DisplayColors() As Long
  ' Returns : The number of colors displayed by the adapter
  ' Source: Total VB SourceBook 6
  '
  Dim lnghDC As Long
  Dim lngTmp As Long
  Dim lngBitsPerPixel As Long
  
  On Error GoTo PROC_ERR
  
  lnghDC = GetDC(0)

  lngBitsPerPixel = GetDeviceCaps(lnghDC, BITSPIXEL) * _
    GetDeviceCaps(lnghDC, PLANES)

  lngTmp = ReleaseDC(0, lnghDC)

  If lngBitsPerPixel = 32 Then
    ' True Color mode
    DisplayColors = -1
  Else
    DisplayColors = 2& ^ lngBitsPerPixel
  End If

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "DisplayColors"
  Resume PROC_EXIT

End Property

Public Property Get GUID() As String
  ' Comments  : Generates a GUID (Globally Unique IDentifier)
  ' Parameters: None
  ' Returns   : Returns a string representation of the GUID
  ' Source: Total VB SourceBook 6
  '
  Dim typGUID As GUID
  Dim strGUID As String
  
  On Error GoTo PROC_ERR

  CoCreateGuid typGUID
   
  strGUID = "{" & Hex$(typGUID.Data1) & "-" & _
    Hex$(typGUID.Data2) & "-" & _
    Hex$(typGUID.Data3) & "-" & _
    Hex$(typGUID.Data4(0)) & _
    Hex$(typGUID.Data4(1)) & _
    Hex$(typGUID.Data4(2)) & _
    Hex$(typGUID.Data4(3)) & _
    Hex$(typGUID.Data4(4)) & _
    Hex$(typGUID.Data4(5)) & _
    Hex$(typGUID.Data4(6)) & _
    Hex$(typGUID.Data4(7)) & _
    "}"

  GUID = strGUID

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "GUID"
  Resume PROC_EXIT
  
End Property

Property Get Language() As String
  ' Returns   : This property returns the user language
  ' Source    : Total VB SourceBook 6
  '
  On Error GoTo PROC_ERR
  
  Const cintLangSize As Integer = 100
  Dim strLanguage As String
  
  strLanguage = Space(cintLangSize)
  'intLangID = GetUserDefaultLCID()
  GetLocaleInfo GetUserDefaultLCID, LOCALE_SENGLANGUAGE, strLanguage, _
    cintLangSize
  Language = TrimNulls(strLanguage)
  
PROC_EXIT:
  Exit Function
  
PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "Language"
  Resume PROC_EXIT


End Property

Property Get LargeFonts() As Boolean
  ' Returns : True if large fonts are displayed, False if small fonts are
  '           displayed
  ' Source: Total VB SourceBook 6

  Dim lnghDC As Long
  Dim lngLogPixelsX As Long
    
  On Error GoTo PROC_ERR
  
  lnghDC = GetDC(0)
  lngLogPixelsX = GetDeviceCaps(lnghDC, LOGPIXELSX)
  ReleaseDC 0, lnghDC
  
  ' If the pixels per inch = 120, then large fonts are in use
  LargeFonts = (lngLogPixelsX = 120)

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "LargeFonts"
  Resume PROC_EXIT

End Property

Property Get OSAdditional() As String
  ' Returns : Additional Information about the operating system version
  ' Source: Total VB SourceBook 6

  Dim typVersion As OSVERSIONINFO
    
  On Error GoTo PROC_ERR
  
  typVersion.dwOSVersionInfoSize = Len(typVersion)
  
  GetVersionEx typVersion
  
  OSAdditional = TrimNulls(typVersion.szCSDVersion)
  
PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "OSAdditional"
  Resume PROC_EXIT

End Property

Property Get OSBuild() As Long
  ' Returns : The operating system build number
  ' Source: Total VB SourceBook 6

  Dim typVersion As OSVERSIONINFO
  Const BuildMask As Long = &H8000
  
  On Error GoTo PROC_ERR
  
  typVersion.dwOSVersionInfoSize = Len(typVersion)
  
  GetVersionEx typVersion
    
  OSBuild = typVersion.dwBuildNumber And Not BuildMask

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "OSBuild"
  Resume PROC_EXIT

End Property

Property Get OSMajorVersion() As Long
  ' Returns : The operating system major version
  ' Source: Total VB SourceBook 6

  Dim typVersion As OSVERSIONINFO
    
  On Error GoTo PROC_ERR
  
  typVersion.dwOSVersionInfoSize = Len(typVersion)
  
  GetVersionEx typVersion
      
  OSMajorVersion = typVersion.dwMajorVersion

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "OSMajorVersion"
  Resume PROC_EXIT

End Property

Property Get OSMinorVersion() As Long
  ' Returns : The operating system minor version
  ' Source: Total VB SourceBook 6

  Dim typVersion As OSVERSIONINFO
    
  On Error GoTo PROC_ERR
  
  typVersion.dwOSVersionInfoSize = Len(typVersion)
  
  GetVersionEx typVersion
  
  OSMinorVersion = typVersion.dwMinorVersion

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "OSMinorVersion"
  Resume PROC_EXIT

End Property

Property Get ScreenSaverActive() As Boolean
  ' Returns : True if screen saving is enabled, False if it is not
  ' Source: Total VB SourceBook 6

  Dim lngOutValue As Long
  
  On Error GoTo PROC_ERR
  
  SystemParametersInfo SPI_GETSCREENSAVEACTIVE, 0, lngOutValue, 0
  ScreenSaverActive = lngOutValue * -1

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "ScreenSaverActive"
  Resume PROC_EXIT

End Property

Property Let ScreenSaverActive(ByVal fValue As Boolean)
  ' fValue : Sets screen saving on or off
  ' Source: Total VB SourceBook 6

  On Error GoTo PROC_ERR
    
  SystemParametersInfo SPI_SETSCREENSAVEACTIVE, fValue * 1, 0, _
    SPIF_SENDWININICHANGE

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "ScreenSaverActive"
  Resume PROC_EXIT

End Property

Property Get ScreenSaverTimeout() As Long
  ' Returns : The screen saver time-out value, in seconds
  ' Source: Total VB SourceBook 6

  Dim lngReturnValue As Long
  
  On Error GoTo PROC_ERR
  
  SystemParametersInfo SPI_GETSCREENSAVETIMEOUT, 0, lngReturnValue, 0
  ScreenSaverTimeout = lngReturnValue

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "ScreenSaverTimeout"
  Resume PROC_EXIT

End Property

Property Let ScreenSaverTimeout(ByVal lngValue As Long)
  ' lngValue : Sets the screen saver timeout, in seconds
  ' Source: Total VB SourceBook 6
  '
  On Error GoTo PROC_ERR

  SystemParametersInfo SPI_SETSCREENSAVETIMEOUT, lngValue * 1, 0, _
    SPIF_SENDWININICHANGE

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "ScreenSaverTimeout"
  Resume PROC_EXIT

End Property

Property Get SystemDirectory() As String
  ' Returns : The windows system directory
  ' Source: Total VB SourceBook 6

  Dim strSystemDirectory As String * MAX_PATH
  
  On Error GoTo PROC_ERR
  
  GetSystemDirectory strSystemDirectory, MAX_PATH
  SystemDirectory = TrimNulls(strSystemDirectory)

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "SystemDirectory"
  Resume PROC_EXIT

End Property

Property Get TempFile(strPrefix As String) As String
  ' Returns    : A temporary file name based on the value of strPrefix.
  ' Source: Total VB SourceBook 6
  '
  Dim strTemp As String
  Dim lngRet As Long
  Dim strTempPath As String
    
  On Error GoTo PROC_ERR
  
  strTempPath = Space$(255)
  lngRet = GetTempPath(Len(strTempPath), strTempPath)
  
  strTemp = Space$(255)
  lngRet = GetTempFileName(strTempPath, strPrefix, 1, ByVal strTemp)
  
  TempFile = TrimNulls(strTemp)

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "TempFile"
  Resume PROC_EXIT

End Property

Property Get TempPath() As String
  ' Returns : The path of the temporary directory
  ' Source: Total VB SourceBook 6

  Dim lngRet As Long
  Dim strTempPath As String
  
  On Error GoTo PROC_ERR
  
  strTempPath = Space$(255)
  lngRet = GetTempPath(Len(strTempPath), strTempPath)
  TempPath = TrimNulls(strTempPath)

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "TempPath"
  Resume PROC_EXIT

End Property

Property Get UserName() As String
  ' Returns : The windows user name
  ' Source: Total VB SourceBook 6
  '
  Const cintStringLength As Integer = 100
  Dim strUserName As String * cintStringLength
  
  On Error GoTo PROC_ERR
  
  GetUserName strUserName, cintStringLength
  UserName = TrimNulls(strUserName)

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "UserName"
  Resume PROC_EXIT

End Property

Property Get WindowsDirectory() As String
  ' Returns : The Windows directory
  ' Source: Total VB SourceBook 6

  Dim strWindowsDirectory As String * MAX_PATH
  On Error GoTo PROC_ERR
  
  GetWindowsDirectory strWindowsDirectory, MAX_PATH
  WindowsDirectory = TrimNulls(strWindowsDirectory)

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "WindowsDirectory"
  Resume PROC_EXIT

End Property

Property Get WindowsType() As EnumWindowsType
  ' Returns : The type of windows
  ' Source: Total VB SourceBook 6

  Dim typVersion As OSVERSIONINFO
  On Error GoTo PROC_ERR

  typVersion.dwOSVersionInfoSize = Len(typVersion)
  GetVersionEx typVersion
  WindowsType = typVersion.dwPlatformId

PROC_EXIT:
  Exit Property

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "WindowsType"
  Resume PROC_EXIT

End Property

Public Sub GetWorkArea( _
  intLeft As Integer, _
  intTop As Integer, _
  intWidth As Integer, _
  intHeight As Integer)
  ' Comments  : Returns the visible area of the desktop, minus the taskbar
  ' Parameters: intLeft - The left position, in pixels, of the work area
  '             intTop - The top position, in pixels, of the work area
  '             intWidth - The width, in pixels, of the work area
  '             intHeight - The height, in pixels, of the work area
  ' Returns   : Nothing
  ' Source    : Total VB SourceBook 6
  '
  Dim rectScreen As RECT
  Dim lngResult As Long
  On Error GoTo PROC_ERR
  
  lngResult = SystemParametersInfo( _
    SPI_GETWORKAREA, _
    0&, _
    ByVal VarPtr(rectScreen), _
    0&)
    
  intLeft = rectScreen.Left
  intTop = rectScreen.Top
  intWidth = rectScreen.Right - rectScreen.Left
  intHeight = rectScreen.Bottom - rectScreen.Top

PROC_EXIT:
  Exit Sub

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "GetWorkArea"
  Resume PROC_EXIT
End Sub

Private Function RegistryGetKeyValue( _
  ByVal lngRootKey As Long, _
  strKeyName As String, _
  strValueName As String) _
  As Variant
  ' Comments  : Returns a value from the system registry
  ' Parameters: lngRootKey - root key value, must be one of the following
  '             strKeyName - The name of the key
  '             strValueName - The name of the value
  ' Returns   : The data in the registry value
  ' Source    : Total VB SourceBook 6
  '
  Dim lngRetVal As Long
  Dim lngHKey As Long
  Dim varValue As Variant
  Dim strValueData As String
  Dim abytValueData() As Byte
  Dim lngValueData As Long
  Dim lngValueType As Long
  Dim lngDataSize As Long
  
  On Error GoTo PROC_ERR
  
  varValue = Empty
  
  lngRetVal = RegOpenKeyEx(lngRootKey, strKeyName, 0&, mcregKeyQueryValue, _
    lngHKey)
  
  If mcregErrorNone = lngRetVal Then
    
    lngRetVal = RegQueryValueExNULL(lngHKey, strValueName, 0&, lngValueType, _
      0&, lngDataSize)
    
    If mcregErrorNone = lngRetVal Then
      
      Select Case lngValueType
      
      ' String type

        Case mcregSZ:
          If lngDataSize > 0 Then
            strValueData = String(lngDataSize, 0)
            lngRetVal = RegQueryValueExString(lngHKey, strValueName, 0&, _
              lngValueType, strValueData, lngDataSize)
            If InStr(strValueData, vbNullChar) > 0 Then
              strValueData = Mid$(strValueData, 1, InStr(strValueData, _
                vbNullChar) - 1)
            End If
          End If
          If mcregErrorNone = lngRetVal Then
            varValue = Left$(strValueData, lngDataSize)
          Else
            varValue = Empty
          End If
        
        ' Long type
        Case mcregDWord:
          lngRetVal = RegQueryValueExLong(lngHKey, strValueName, 0&, _
            lngValueType, lngValueData, lngDataSize)
          If mcregErrorNone = lngRetVal Then
            varValue = lngValueData
          End If
        
        
        ' Binary type
        Case mcregBinary
          If lngDataSize > 0 Then
            ReDim abytValueData(lngDataSize)
            lngRetVal = RegQueryValueExBinary(lngHKey, strValueName, 0&, _
              lngValueType, VarPtr(abytValueData(0)), lngDataSize)
          End If
          If mcregErrorNone = lngRetVal Then
            varValue = abytValueData
          Else
            varValue = Empty
          End If
        
        
      Case Else
        'No other data types supported
        lngRetVal = -1
        
      End Select
      
    End If
    
    RegCloseKey (lngHKey)
  End If
  
  'Return varValue
  RegistryGetKeyValue = varValue
PROC_EXIT:
  Exit Function

PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "RegistryGetKeyValue"
  Resume PROC_EXIT
End Function

Private Function TrimNulls(ByVal strIn As String) As String
  ' Comments  : Returns the passed string terminated at the first null
  ' Parameters: strIn - Value to parse
  ' Returns   : Parsed string
  ' Source    : Total VB SourceBook 6
  '
  Dim intPos As Integer
  
  On Error GoTo PROC_ERR
    
  intPos = InStr(strIn, vbNullChar)
  
  If intPos = 0 Then
    ' No nulls in the string, just return it as is
    TrimNulls = strIn
  Else
    If intPos = 1 Then
      ' If the null character is at the first position, the
      ' entire string is a null string, so return a zero-length string
      TrimNulls = ""
    Else
      ' Not at the first position, so return the contents up
      ' to the occurrence of the null character
      TrimNulls = Left$(strIn, intPos - 1)
    End If
  End If
    
PROC_EXIT:
  Exit Function
  
PROC_ERR:
  MsgBox "Error: " & Err.Number & ". " & Err.Description, , _
    "TrimNulls"
  Resume PROC_EXIT
    
End Function


