Attribute VB_Name = "Sysmenus"
Option Explicit

'BEISPIEL FR DAS HINZUFGEN VON EINTRGEN IN DAS SYSTEMMEN.
'KLICKEN SIE AN DAS LINKE OBERE SYMBOL (WENN GESTARTET) UM ES AUFZURUFEN.
'FGEN SIE DIESEN QUELLTEXT IN DIE FORM_LOAD ANWEISUNG EIN:
    'HookForm Me
    'AddItemToSysMenu "Ausschneiden", 110, 0
    'AddItemToSysMenu "Kopieren", 120, 1
    'AddItemToSysMenu "Einfgen", 130, 2
    'AddItemToSysMenu "Lschen", 140, 3
    'AddItemToSysMenu "-", 150, 4


'** Men-Funktionen
Declare Function GetSystemMenu Lib "user32" ( _
ByVal hWnd As Long, _
ByVal bRevert As Long) _
As Long

Declare Function InsertMenu Lib "user32" Alias "InsertMenuA" ( _
ByVal hMenu As Long, _
ByVal nPosition As Long, _
ByVal wFlags As Long, _
ByVal wIDNewItem As Long, _
ByVal lpNewItem As Any) _
As Long

Const MF_BYPOSITION = &H400&
Const MF_STRING = &H0&
Const MF_SEPARATOR = &H800&
Const WM_SYSCOMMAND = &H112

'** MessageHook-Funktionen
Declare Function CallWindowProc Lib "user32" Alias "CallWindowProcA" ( _
ByVal lpPrevWndFunc As Long, _
ByVal hWnd As Long, _
ByVal Msg As Long, _
ByVal wParam As Long, _
ByVal lParam As Long) _
As Long

Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" ( _
ByVal hWnd As Long, _
ByVal nIndex As Long, _
ByVal dwNewLong As Long) _
As Long

Const GWL_WNDPROC = -4

'** Modulvariablen
Dim OldWndProc As Long
Dim SysMenuOwner As Form

Public Sub HookForm(F As Form)
    ' angegebene Form einklinken!
    If OldWndProc Then UnhookForm
    'wenn schon eingeklinkt: erst ausklinken
    Set SysMenuOwner = F
    'Form speichern (zum Aufrufen der Formprozedur)
    OldWndProc = SetWindowLong(SysMenuOwner.hWnd, GWL_WNDPROC, AddressOf newWndProc)
    ' Alte Prozedur speichern und neue einklinken
End Sub

Public Sub UnhookForm()
    'Form ausklinken (sptestens beim Entladen der Form!)
    If OldWndProc = 0 Then Exit Sub
    'wenn nicht eingeklinkt: Abbruch!
    SetWindowLong SysMenuOwner.hWnd, GWL_WNDPROC, OldWndProc
    'Alte WndProc wiederherstellen
    OldWndProc = 0
    Set SysMenuOwner = Nothing
    'Variablen zurcksetzen
End Sub

Function newWndProc(ByVal hWnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    ' Callback-Funktion: Nachrichten abfangen
    If uMsg = WM_SYSCOMMAND Then 'Systemmen
        If (wParam And &HF000) = 0 Then
            'wenn kein Windows-Standardeintrag:
            On Error Resume Next  'Fehler ignorieren (sonst wrde das Programm abstrzen)
            'Funktion aufrufen
            SysMenuOwner.SysMenuClicked wParam
        End If
    End If
    'Alte WndProc-Funktion aufrufen (Nachrichten weiterleiten)
    newWndProc = CallWindowProc(OldWndProc, hWnd, uMsg, wParam, lParam)
End Function

'  AddItemToSysMenu -- Eintrag an Systemmen anhngen
'  MenuCaption   = Caption ("" oder "-": Separator)
'  MenuCaptionID = Kennung fr Auswertung
'  Position      = Position im Systemmen (wenn fehlt: Anhngen)
Sub AddItemToSysMenu(Optional MenuCaption As String, Optional MenuID As Long, Optional Position As Long = -1)
    Dim hMenu As Long, Flags As Long
    If OldWndProc = 0 Then Exit Sub
    If MenuCaption = "-" Or MenuCaption = "" Then Flags = MF_SEPARATOR Else Flags = MF_STRING
    hMenu = GetSystemMenu(SysMenuOwner.hWnd, False)
    'Systemmen-Handle ermitteln
    InsertMenu hMenu, Position, Flags Or MF_BYPOSITION, MenuID, MenuCaption
    'Meneintrag einfgen
End Sub

Sub ResetSysMenu()
    If OldWndProc = 0 Then Exit Sub
    GetSystemMenu SysMenuOwner.hWnd, True
    'Original-Systemmen wiederherstellen
End Sub
