Attribute VB_Name = "NumCapScroll"
' Declare Type for API-Call:
Private Type OSVERSIONINFO
dwOSVersionInfoSize As Long
dwMajorVersion As Long
dwMinorVersion As Long
dwBuildNumber As Long
dwPlatformId As Long
szCSDVersion As String * 128   '  Maintenance string for PSS usage
End Type

' API-Declarations:
Private Declare Function GetVersionEx Lib "kernel32" Alias "GetVersionExA" _
(lpVersionInformation As OSVERSIONINFO) As Long
Private Declare Sub keybd_event Lib "user32" (ByVal bVk As Byte, ByVal _
bScan As Byte, ByVal dwFlags As Long, ByVal dwExtraInfo As Long)
Private Declare Function GetKeyboardState Lib "user32" _
(pbKeyState As Byte) As Long
Private Declare Function SetKeyboardState Lib "user32" _
(lppbKeyState As Byte) As Long

' Constant-Declarations:
Const VK_NUMLOCK = &H90
Const VK_SCROLL = &H91
Const VK_CAPITAL = &H14
Const KEYEVENTF_EXTENDEDKEY = &H1
Const KEYEVENTF_KEYUP = &H2
Const VER_PLATFORM_WIN32_NT = 2
Const VER_PLATFORM_WIN32_WINDOWS = 1
    
'AKTIVIERUNG DER [NUM], [CAP], [SCROLL] -TASTEN
Function NumLock_SetOn()
    Dim o As OSVERSIONINFO
    Dim NumLockState As Boolean
    Dim ScrollLockState As Boolean
    Dim CapsLockState As Boolean
    
    o.dwOSVersionInfoSize = Len(o)
    GetVersionEx o
    Dim keys(0 To 255) As Byte
    GetKeyboardState keys(0)
    ' NumLock handling:
    NumLockState = keys(VK_NUMLOCK)
    If NumLockState <> True Then    'Turn numlock on
        If o.dwPlatformId = VER_PLATFORM_WIN32_WINDOWS Then  '===== Win95
            keys(VK_NUMLOCK) = 1
            SetKeyboardState keys(0)
            ElseIf o.dwPlatformId = VER_PLATFORM_WIN32_NT Then   '===== WinNt
            'Simulate Key Press
            keybd_event VK_NUMLOCK, &H45, KEYEVENTF_EXTENDEDKEY Or 0, 0
            'Simulate Key Release
            keybd_event VK_NUMLOCK, &H45, KEYEVENTF_EXTENDEDKEY _
            Or KEYEVENTF_KEYUP, 0
        End If
    End If
End Function

'AKTIVIERUNG DER [NUM], [CAP], [SCROLL] -TASTEN
Function CapLock_SetOn()
    Dim o As OSVERSIONINFO
    Dim NumLockState As Boolean
    Dim ScrollLockState As Boolean
    Dim CapsLockState As Boolean
    
    o.dwOSVersionInfoSize = Len(o)
    GetVersionEx o
    Dim keys(0 To 255) As Byte
    GetKeyboardState keys(0)
    ' CapsLock handling:
    CapsLockState = keys(VK_CAPITAL)
    If CapsLockState <> True Then    'Turn capslock on
        If o.dwPlatformId = VER_PLATFORM_WIN32_WINDOWS Then  '===== Win95
            keys(VK_CAPITAL) = 1
            SetKeyboardState keys(0)
            ElseIf o.dwPlatformId = VER_PLATFORM_WIN32_NT Then   '===== WinNt
            'Simulate Key Press
            keybd_event VK_CAPITAL, &H45, KEYEVENTF_EXTENDEDKEY Or 0, 0
            'Simulate Key Release
            keybd_event VK_CAPITAL, &H45, KEYEVENTF_EXTENDEDKEY _
            Or KEYEVENTF_KEYUP, 0
        End If
    End If
End Function

'AKTIVIERUNG DER [NUM], [CAP], [SCROLL] -TASTEN
Function Scroll_SetOn()
    Dim o As OSVERSIONINFO
    Dim NumLockState As Boolean
    Dim ScrollLockState As Boolean
    Dim CapsLockState As Boolean
    
    o.dwOSVersionInfoSize = Len(o)
    GetVersionEx o
    Dim keys(0 To 255) As Byte
    GetKeyboardState keys(0)
    ' ScrollLock handling:
    ScrollLockState = keys(VK_SCROLL)
    If ScrollLockState <> True Then    'Turn Scroll lock on
        If o.dwPlatformId = VER_PLATFORM_WIN32_WINDOWS Then  '===== Win95
            keys(VK_SCROLL) = 1
            SetKeyboardState keys(0)
            ElseIf o.dwPlatformId = VER_PLATFORM_WIN32_NT Then   '===== WinNt
            'Simulate Key Press
            keybd_event VK_SCROLL, &H45, KEYEVENTF_EXTENDEDKEY Or 0, 0
            'Simulate Key Release
            keybd_event VK_SCROLL, &H45, KEYEVENTF_EXTENDEDKEY _
            Or KEYEVENTF_KEYUP, 0
        End If
    End If
End Function



