Attribute VB_Name = "Registry"

'So schreiben Sie Werte in verschiedenen Stringformen:
'------------------------------------------------------------------------------------------------------------
    'ZEICHENFOLGE                       >>>       "0"                        >>>    0
    'MEHRZEILIGE ZEICHENFOLGE   >>>       "xxxx" & Chr(13)    >>>    xxxx & <Enter>
    'DWORD-WERT                        >>>      0                            >>>    0x00000000 (0)
    'BINR-WERT                           >>>      vbNull - 1                >>>    00 00 00 00
'------------------------------------------------------------------------------------------------------------

Option Explicit

Public Const HKEY_CLASSES_ROOT = &H80000000
Public Const HKEY_CURRENT_USER = &H80000001
Public Const HKEY_LOCAL_MACHINE = &H80000002
Public Const HKEY_USERS = &H80000003
Public Const HKEY_PERFORMANCE_DATA = &H80000004
Public Const HKEY_CURRENT_CONFIG = &H80000005
Public Const HKEY_DYN_DATA = &H80000006

Const KEY_QUERY_VALUE = &H1
Const KEY_SET_VALUE = &H2
Const KEY_CREATE_SUB_KEY = &H4
Const KEY_ENUMERATE_SUB_KEYS = &H8
Const KEY_NOTIFY = &H10
Const KEY_CREATE_LINK = &H20
Const KEY_READ = KEY_QUERY_VALUE Or KEY_ENUMERATE_SUB_KEYS Or KEY_NOTIFY
Const KEY_WRITE = KEY_SET_VALUE Or KEY_CREATE_SUB_KEY
Const KEY_EXECUTE = KEY_READ
Const KEY_ALL_ACCESS = KEY_QUERY_VALUE Or KEY_SET_VALUE Or KEY_CREATE_SUB_KEY Or KEY_ENUMERATE_SUB_KEYS Or KEY_NOTIFY Or KEY_CREATE_LINK
Const ERROR_SUCCESS = 0&

Const REG_NONE = 0      ' No value type
Const REG_SZ = 1        ' Unicode nul terminated string
Const REG_EXPAND_SZ = 2 ' Unicode nul terminated string (with environment variable references)
Const REG_BINARY = 3    ' Free form binary
Const REG_DWORD = 4     ' 32-bit number
Const REG_DWORD_LITTLE_ENDIAN = 4 ' 32-bit number (same as REG_DWORD)
Const REG_DWORD_BIG_ENDIAN = 5    ' 32-bit number
Const REG_LINK = 6                ' Symbolic Link (unicode)
Const REG_MULTI_SZ = 7            ' Multiple Unicode strings

Const REG_OPTION_NON_VOLATILE = &H0
Const REG_CREATED_NEW_KEY = &H1


Declare Function RegOpenKeyEx Lib "advapi32.dll" Alias "RegOpenKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal ulOptions As Long, ByVal samDesired As Long, phkResult As Long) As Long
Declare Function RegCloseKey Lib "advapi32.dll" (ByVal hKey As Long) As Long
Declare Function RegQueryValueEx Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, lpData As Any, lpcbData As Any) As Long
Declare Function RegCreateKeyEx Lib "advapi32.dll" Alias "RegCreateKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal Reserved As Long, ByVal lpClass As String, ByVal dwOptions As Long, ByVal samDesired As Long, ByVal lpSecurityAttributes As Any, phkResult As Long, lpdwDisposition As Long) As Long
Declare Function RegFlushKey Lib "advapi32.dll" (ByVal hKey As Long) As Long
Declare Function RegSetValueEx_String Lib "advapi32.dll" Alias "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, ByVal lpData As String, ByVal cbData As Long) As Long
Declare Function RegSetValueEx_DWord Lib "advapi32.dll" Alias "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, lpData As Long, ByVal cbData As Long) As Long
Declare Function RegDeleteKey Lib "advapi32.dll" Alias "RegDeleteKeyA" (ByVal hKey As Long, ByVal lpSubKey As String) As Long
Declare Function RegDeleteValue Lib "advapi32.dll" Alias "RegDeleteValueA" (ByVal hKey As Long, ByVal lpValueName As String) As Long

' PRFT OB EIN SCHLSSEL VORHANDEN IST
' Diese Funktion sollten Sie aufrufen bevor Sie einen neuen Eintrag hinzufgen

Function ExistKey(Root&, schlssel$) As Boolean
' Root ist entweder HKEY_CURRENT_USER oder HKEY_LOCAL_MACHINE
Dim lResult&, keyhandle&

    lResult = RegOpenKeyEx(Root, schlssel, 0, KEY_READ, keyhandle)
    If lResult = ERROR_SUCCESS Then RegCloseKey keyhandle
    ExistKey = (lResult = ERROR_SUCCESS)
End Function

' SCHLSSEL ERSTELLEN
Function CreateKey(Root&, newkey$, class$) As Boolean
Dim lResult&, keyhandle&
Dim Action&

   lResult = RegCreateKeyEx(Root, newkey, 0, class, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0&, keyhandle, Action)
   If lResult = ERROR_SUCCESS Then
       If RegFlushKey(keyhandle) = ERROR_SUCCESS Then RegCloseKey keyhandle
   Else
     CreateKey = False
     Exit Function
   End If
   CreateKey = (Action = REG_CREATED_NEW_KEY)
End Function

' SCHLSSEL LSCHEN
Function DeleteKey(Root&, key$) As Boolean
Dim lResult&
    lResult = RegDeleteKey(Root, key)
    DeleteKey = (lResult = ERROR_SUCCESS)
End Function

' WERT SCHREIBEN
Function SetValue(Root&, key$, field$, value As Variant) As Boolean
Dim lResult&, keyhandle&
Dim s$, l&
    
    lResult = RegOpenKeyEx(Root, key, 0, KEY_ALL_ACCESS, keyhandle)
    If lResult <> ERROR_SUCCESS Then
        SetValue = False
        Exit Function
    End If
    
    Select Case VarType(value)
        'BINR-WERT  <<<<<<<<<<NEU>>>>>>>>>>
        Case vbLong
            l = CLng(value)
            lResult = RegSetValueEx_DWord(keyhandle, field, 0, REG_BINARY, l, 4)
            
        'DWORD-WERT
        Case vbInteger ', vbLong
            'DWORD-WERT
            l = CLng(value)
            lResult = RegSetValueEx_DWord(keyhandle, field, 0, REG_DWORD, l, 4)
        
        'ZEICHENFOLGE
        Case vbString
            If InStr(1, value, Chr(13), 1) = 0 Then
                s = CStr(value)
                lResult = RegSetValueEx_String(keyhandle, field, 0, REG_SZ, s, Len(s) + 1)    ' +1 fr die Null am Ende
            Else
                s = CStr(value)
                If Not Right$(s, 2) = Chr(13) & Chr(10) Then s = s & Chr(13) & Chr(10)
                lResult = RegSetValueEx_String(keyhandle, field, 0, REG_MULTI_SZ, s, Len(s) + 1)    ' +1 fr die Null am Ende
            End If
        
        ' Hier knnen noch weitere Datentypen umgewandelt bzw. gespeichert werden
    End Select
    RegCloseKey keyhandle
    SetValue = (lResult = ERROR_SUCCESS)
End Function

' WERT AUSLESEN
' Liefert den Wert eines Eintrags, der durch Root, Schlssel und Feld spezifiziert wird
Function GetValue(Root&, key$, field$, value As Variant) As Boolean
Dim lResult&, keyhandle&, dwType&
Dim zw&, puffergre&, puffer$

    lResult = RegOpenKeyEx(Root, key, 0, KEY_READ, keyhandle)
    GetValue = (lResult = ERROR_SUCCESS)
    If lResult <> ERROR_SUCCESS Then Exit Function ' Schlssel existiert nicht
    lResult = RegQueryValueEx(keyhandle, field, 0&, dwType, ByVal 0&, puffergre)
    GetValue = (lResult = ERROR_SUCCESS)
    If lResult <> ERROR_SUCCESS Then Exit Function ' Feld existiert nicht
    Select Case dwType
        
        'ZEICHENFOLGE
        Case REG_SZ       ' nullterminierter String (dwType = 1)
            puffer = Space$(puffergre + 1)
            lResult = RegQueryValueEx(keyhandle, field, 0&, dwType, ByVal puffer, puffergre)
            GetValue = (lResult = ERROR_SUCCESS)
            If lResult <> ERROR_SUCCESS Then Exit Function ' Fehler beim auslesen des Feldes
            value = puffer
        
        'ZEICHENFOLGE INCL ANHNGENDER VARIABLEN (dwType = 2)
        Case REG_EXPAND_SZ
            puffer = Space$(puffergre + 1)
            lResult = RegQueryValueEx(keyhandle, field, 0&, dwType, ByVal puffer, puffergre)
            GetValue = (lResult = ERROR_SUCCESS)
            If lResult <> ERROR_SUCCESS Then Exit Function ' Fehler beim auslesen des Feldes
            value = puffer
        
        'DWORD-WERT (dwType = 4)
        Case REG_DWORD     ' 32-Bit Number   !!!! Word
            puffergre = 4      ' = 32 Bit
            lResult = RegQueryValueEx(keyhandle, field, 0&, dwType, zw, puffergre)
            GetValue = (lResult = ERROR_SUCCESS)
            If lResult <> ERROR_SUCCESS Then Exit Function ' Fehler beim auslesen des Feldes
            value = zw
        
        'BINR-WERT (dwType = 3) <<<<<<<<<<NEU>>>>>>>>>>
        Case REG_BINARY     ' 32-Bit Number  ??? Word
            puffergre = 4      ' = 32 Bit
            lResult = RegQueryValueEx(keyhandle, field, 0&, dwType, zw, puffergre)
            GetValue = (lResult = ERROR_SUCCESS)
            If lResult <> ERROR_SUCCESS Then Exit Function ' Fehler beim auslesen des Feldes
            value = zw
            
        'ZEICHENFOLGE INCL ANHNGENDER VARIABLEN (dwType = 2)
        Case REG_MULTI_SZ
            puffer = Space$(puffergre + 1)
            lResult = RegQueryValueEx(keyhandle, field, 0&, dwType, ByVal puffer, puffergre)
            GetValue = (lResult = ERROR_SUCCESS)
            If lResult <> ERROR_SUCCESS Then Exit Function ' Fehler beim auslesen des Feldes
            value = puffer
            
        ' Hier knnten auch die weiteren Datentypen behandelt werden, soweit dies sinnvoll ist
    End Select
    If lResult = ERROR_SUCCESS Then RegCloseKey keyhandle
    GetValue = True
End Function

' WERT LSCHEN
Function DeleteValue(Root&, key$, field$) As Boolean
Dim lResult&, keyhandle&
    
    lResult = RegOpenKeyEx(Root, key, 0, KEY_ALL_ACCESS, keyhandle)
    If lResult <> ERROR_SUCCESS Then
        DeleteValue = False
        Exit Function
    End If
    lResult = RegDeleteValue(keyhandle, field)
    DeleteValue = (lResult = ERROR_SUCCESS)
    RegCloseKey keyhandle
End Function


