Attribute VB_Name = "SpecialFolders"
Option Explicit

Private Type SHITEMID
  cb As Long
  abID As Byte
End Type

Private Type ITEMIDLIST
  mkid As SHITEMID
End Type

Private Declare Function SHGetSpecialFolderLocation Lib "shell32.dll" _
(ByVal hwndOwner As Long, ByVal nFolder As Long, pidl As ITEMIDLIST) As Long

Private Declare Function SHGetPathFromIDList Lib "shell32.dll" Alias _
"SHGetPathFromIDListA" (ByVal pidl As Long, ByVal pszPath As String) As Long

Public Enum SHELLFOLDERID
    CRIDL_DESKTOP = &H0&       ' Desktop
    CRIDL_PROGRAMS = &H2&      ' Programme (Startmen)
    CRIDL_PERSONAL = &H5&      ' Eigene Dateien
    CRIDL_FAVORITES = &H6&     ' Favoriten
    CRIDL_STARTUP = &H7&       ' Autostart
    CRIDL_RECENT = &H8&        ' Dokumente
    CRIDL_SENDTO = &H9&        ' Senden An
    CRIDL_STARTMENU = &HB&     ' Startmen
    CRIDL_DESKTOPDIRECTORY = &H10& ' Desktop
    CRIDL_NETWORK = &H12&       ' Netzwerkumgebung
    CRIDL_NETHOOD = &H13&       ' Netzwerk (Arbeitsgruppe)
    CRIDL_FONTS = &H14&         ' Schiftenarten
    CRIDL_TEMPLATES = &H15&     ' Vorlagen
    CRIDL_COMMON_STARTMENU = &H16&  ' Alle Benutzer (Startmen)
    CRIDL_COMMON_PROGRAMS = &H17&  ' Alle Benutzer (Programme)
    CRIDL_COMMON_STARTUP = &H18&  ' Alle Benutzer (Autostart)
    CRIDL_COMMON_DESKTOPDIRECTORY = &H19&  ' Alle Benutzer (Desktop)
    CRIDL_APPDATA = &H1A&  ' Anwendungsdaten
    CRIDL_PRINTHOOD = &H1B&  ' Druckauftragsordner
    CRIDL_COMMON_FAVORITEN = &H1F  'Alle Benutzer (Favoriten)
    CRIDL_INTERNETCACHE = &H20  'Temporre Internetdateien
    CRIDL_COOKIES = &H21  'Cookie (Zwischenspeicher)
    CRIDL_HISTORY = &H22  'Internet History
    CRIDL_APPDATE = &H23  'Alle Benutzer (Anwendungsdaten)
    CRIDL_WINDOWS = &H24  'Windows Verzeichnis
    CRIDL_SYSTEM = &H25  'System Verzeichnis
    CRIDL_PROGRAMME = &H26  'Programme
    CRIDL_PICTURES = &H27  'Eigene Bilder
End Enum

Public Function GetSpecialFolderPath(ByVal FolderID As SHELLFOLDERID) As String
    Dim nItemList As ITEMIDLIST
    Dim nPath As String
    
    Const NOERROR = 0
    If SHGetSpecialFolderLocation(0, FolderID, nItemList) = NOERROR Then
        nPath = Space$(260)
        If SHGetPathFromIDList(nItemList.mkid.cb, nPath) <> 0 Then
            GetSpecialFolderPath = Left$(nPath, InStr(nPath, vbNullChar) - 1)
        End If
    End If
End Function


